/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	$Id: pkcs8_asn.c,v 1.5 2001/01/25 22:11:42 jeffc Exp $
____________________________________________________________________________*/
/*******************************************************************
 *
 * This file was generated by TIS/ASN1COMP Ver. 4.3, an ASN.1 compiler.
 * TIS/ASN1COMP is Copyright (c) 1998, TIS Labs at Network Associates, Inc.
 *
 * This file was AUTOMATICALLY GENERATED on Mon Aug  2 15:55:31 1999
 *
 ******************************************************************/


#include <string.h>

#include "pkcs8_asn.h"

/*******************************************************************
 *
 * Code for manipulating ASN.1 DER data and structure.
 *
 *  NewXXX: Allocate the top level of a structure.
 *
 *  FreeXXX: Release all the data of an ASN structure.
 *
 *  SizeofXXX: Return the size of the DER block that would
 *               be created from the structure.
 *
 *  PackXXX: Take an ASN structure and return the DER.
 *
 *  unPackXXX: Take the DER and return an ASN structure.
 *
 ******************************************************************/


/******************************************************************
 * Routines for EncryptedPrivateKeyInfo
 ******************************************************************/

PKIEncryptedPrivateKeyInfo *PKINewEncryptedPrivateKeyInfo(
    PKICONTEXT *ctx)
{
    PKIEncryptedPrivateKeyInfo *f;

    if (ctx == NULL)
        return NULL;

    f = (PKIEncryptedPrivateKeyInfo *)PKIAlloc(ctx->memMgr, sizeof(PKIEncryptedPrivateKeyInfo));
    if (f != NULL)
        (void)memset(f, 0, sizeof(PKIEncryptedPrivateKeyInfo));
    return (f);

} /* PKINewEncryptedPrivateKeyInfo */

void PKIFreeEncryptedPrivateKeyInfo(
    PKICONTEXT *ctx,
    PKIEncryptedPrivateKeyInfo *f)
{
    if (ctx == NULL)
        return;

    PKIDropInPlaceEncryptedPrivateKeyInfo(ctx, f);
    if (f != NULL)
        PKIFree(ctx->memMgr, f);

} /* PKIFreeEncryptedPrivateKeyInfo */

size_t PKISizeofEncryptedPrivateKeyInfo(
    PKICONTEXT *ctx,
    PKIEncryptedPrivateKeyInfo *asnstruct,
    int outerSizeFlag)
{
    (void)ctx; /* for future use */

    return(PKISizeofEncryptedPrivateKeyInfoInternal(asnstruct, outerSizeFlag, PKIFALSE));
} /* PKISizeofEncryptedPrivateKeyInfo */

size_t PKIPackEncryptedPrivateKeyInfo(
    PKICONTEXT *ctx,
    unsigned char *buf,
    size_t buflen,
    PKIEncryptedPrivateKeyInfo *asnstruct,
    int *erret )
{
    return(PKIPackEncryptedPrivateKeyInfoInternal(ctx, buf, buflen, asnstruct, PKIID_EncryptedPrivateKeyInfo, erret));
} /* PKIPackEncryptedPrivateKeyInfo */

size_t PKIUnpackEncryptedPrivateKeyInfo(
    PKICONTEXT *ctx,
    PKIEncryptedPrivateKeyInfo **asnstruct,
    const unsigned char *buf,
    size_t buflen,
    int *erret)
{
    size_t bytesused;
    bytesused=PKIUnpackEncryptedPrivateKeyInfoInternal(ctx, asnstruct, buf, buflen,
                      PKIID_EncryptedPrivateKeyInfo, erret);
    if(*erret==0 && bytesused==0)
        PKIERR(PKIErrUnpackUnderrun);
    return bytesused;
}

/******************************************************************
 * Routines for PrivateKeyInfo
 ******************************************************************/

PKIPrivateKeyInfo *PKINewPrivateKeyInfo(
    PKICONTEXT *ctx)
{
    PKIPrivateKeyInfo *f;

    if (ctx == NULL)
        return NULL;

    f = (PKIPrivateKeyInfo *)PKIAlloc(ctx->memMgr, sizeof(PKIPrivateKeyInfo));
    if (f != NULL)
        (void)memset(f, 0, sizeof(PKIPrivateKeyInfo));
    return (f);

} /* PKINewPrivateKeyInfo */

void PKIFreePrivateKeyInfo(
    PKICONTEXT *ctx,
    PKIPrivateKeyInfo *f)
{
    if (ctx == NULL)
        return;

    PKIDropInPlacePrivateKeyInfo(ctx, f);
    if (f != NULL)
        PKIFree(ctx->memMgr, f);

} /* PKIFreePrivateKeyInfo */

size_t PKISizeofPrivateKeyInfo(
    PKICONTEXT *ctx,
    PKIPrivateKeyInfo *asnstruct,
    int outerSizeFlag)
{
    (void)ctx; /* for future use */

    return(PKISizeofPrivateKeyInfoInternal(asnstruct, outerSizeFlag, PKIFALSE));
} /* PKISizeofPrivateKeyInfo */

size_t PKIPackPrivateKeyInfo(
    PKICONTEXT *ctx,
    unsigned char *buf,
    size_t buflen,
    PKIPrivateKeyInfo *asnstruct,
    int *erret )
{
    return(PKIPackPrivateKeyInfoInternal(ctx, buf, buflen, asnstruct, PKIID_PrivateKeyInfo, erret));
} /* PKIPackPrivateKeyInfo */

size_t PKIUnpackPrivateKeyInfo(
    PKICONTEXT *ctx,
    PKIPrivateKeyInfo **asnstruct,
    const unsigned char *buf,
    size_t buflen,
    int *erret)
{
    size_t bytesused;
    bytesused=PKIUnpackPrivateKeyInfoInternal(ctx, asnstruct, buf, buflen,
                      PKIID_PrivateKeyInfo, erret);
    if(*erret==0 && bytesused==0)
        PKIERR(PKIErrUnpackUnderrun);
    return bytesused;
}
